<%*
// Retrieve the "Note type" from the front matter
const noteType = tp.frontmatter['Note type'];

// Common variables
const dv = this.app.plugins.plugins["dataview"].api;
const curr = tp.config.target_file;
const dvCurr = dv.page(curr.path);
const baseFolder = app.vault.getAbstractFileByPath(dvCurr.file.folder);
const relatedAreas = tp.frontmatter["Related areas"];
const formattedRelatedAreas = Array.isArray(relatedAreas) 
    ? relatedAreas.map(area => "- \"" + area + "\"").join("\n")
    : relatedAreas ? "- \"" + relatedAreas + "\"" : ""; // Handle the case where it's not an array
const relatedProjects = tp.frontmatter["Related projects"];
const formattedRelatedProjects = Array.isArray(relatedProjects) 
    ? relatedProjects.map(project => "- \"" + project + "\"").join("\n")
    : relatedProjects ? "- \"" + relatedProjects + "\"" : ""; // Handle the case where it's not an array
const relatedTasks = tp.frontmatter["Related tasks"];
const formattedRelatedTasks = Array.isArray(relatedTasks)
    ? relatedTasks.map(task => "- \"" + task + "\"").join("\n")
    : relatedTasks ? "- \"" + relatedTasks + "\"" : ""; // Handle the case where it's not an array
const relatedMeetingNotes = tp.frontmatter["Related meeting notes"]; 
const formattedRelatedMeetingNotes = Array.isArray(relatedMeetingNotes) 
	? relatedMeetingNotes.map(meeting => "- \"" + meeting + "\"").join("\n")
	: relatedMeetingNotes ? "- \"" + relatedMeetingNotes + "\"" : ""; // Handle the case where it's not an array
const relatedPeople = tp.frontmatter["Related people"];
const formattedRelatedPeople = Array.isArray(relatedPeople)
    ? relatedPeople.map(person => "- \"" + person + "\"").join("\n")
    : relatedPeople ? "- \"" + relatedPeople + "\"" : ""; // Handle the case where it's not an array
const date = tp.date.now("YYYY-MM-DD"); // Get current date formatted as YYYY-MM-DD

const newFile = await tp.system.prompt("New file name");
if (!newFile) return; // Exit if no file name is provided

let content = "";

// Conditional logic to determine which script to execute based on the note type
switch(noteType) {
    case 'Area':
        content = 
`---
Note type: Person
tags:
  - "#Person"
Person type: 
Email:
Phone:
Twitter:
Linkedin:
Facebook:
Address:
Related areas:
- "[[${tp.file.title}]]"
${formattedRelatedAreas}
Related projects:
${formattedRelatedProjects}
Related tasks:
Related MoCs:
Related references:
Related zettels:
Related meeting notes:
${formattedRelatedMeetingNotes}
Related resources:
Related people:
aliases:
Creation date: "${date}"
Last modified: ${date}
---
`;
        break;
    case 'Project':
        content = 
`---
Note type: Person
tags:
  - "#Person"
Person type: 
Email:
Phone:
Twitter:
Linkedin:
Facebook:
Address:
Related areas:
${formattedRelatedAreas}
Related projects:
- "[[${tp.file.title}]]"
${formattedRelatedProjects}
Related tasks:
Related MoCs:
Related references:
Related zettels:
Related meeting notes:
${formattedRelatedMeetingNotes}
Related resources:
Related people:
${formattedRelatedPeople}
aliases:
Creation date: "${date}"
Last modified: ${date}
---
`;
        break;
    case 'Task':
        content = 
`---
Note type: Person
tags:
  - "#Person"
Person type: 
Email:
Phone:
Twitter:
Linkedin:
Facebook:
Address:
Related areas:
${formattedRelatedAreas}
Related projects:
${formattedRelatedProjects}
Related tasks:
- "[[${tp.file.title}]]"
Related MoCs:
Related references:
Related zettels:
Related meeting notes:
${formattedRelatedMeetingNotes}
Related resources:
Related people:
${formattedRelatedPeople}
aliases:
Creation date: "${date}"
Last modified: ${date}
---
`;
        break;
    case 'Meeting':
    case 'Resource':
        content = 
`---
Note type: Person
tags:
  - "#Person"
Person type: 
Email:
Phone:
Twitter:
Linkedin:
Facebook:
Address:
Related areas:
${formattedRelatedAreas}
Related projects:
${formattedRelatedProjects}
Related tasks:
Related MoCs:
Related references:
Related zettels:
Related meeting notes:
${formattedRelatedMeetingNotes}
Related resources:
- "[[${tp.file.title}]]"
Related people:
${formattedRelatedPeople}
aliases:
Creation date: "${date}"
Last modified: ${date}
---
`;
        break;
    case 'Reference':
        content = 
`---
Note type: Person
tags:
  - "#Person"
Person type: 
Email:
Phone:
Twitter:
Linkedin:
Facebook:
Address:
Related areas:
${formattedRelatedAreas}
Related projects:
${formattedRelatedProjects}
Related tasks:
Related MoCs:
Related references:
- "[[${tp.file.title}]]"
Related zettels:
Related meeting notes:
${formattedRelatedMeetingNotes}
Related resources:
Related people:
${formattedRelatedPeople}
aliases:
Creation date: "${date}"
Last modified: ${date}
---
`;
        break;
    case 'Zettel':
    case 'MoC':
        content = 
`---
Note type: Person
tags:
  - "#Person"
Person type: 
Email:
Phone:
Twitter:
Linkedin:
Facebook:
Address:
Related areas:
${formattedRelatedAreas}
Related projects:
${formattedRelatedProjects}
Related tasks:
Related MoCs:
Related references:
Related zettels:
Related meeting notes:
${formattedRelatedMeetingNotes}
- "[[${tp.file.title}]]"
Related resources:
Related people:
${formattedRelatedPeople}
aliases:
Creation date: "${date}"
Last modified: ${date}
---
`;
        break;
    case 'Person':
        content = 
`---
Note type: Person
tags:
  - "#Person"
Person type: 
Email:
Phone:
Twitter:
Linkedin:
Facebook:
Address:
Related areas:
${formattedRelatedAreas}
Related projects:
${formattedRelatedProjects}
Related tasks:
Related MoCs:
Related references:
Related zettels:
Related meeting notes:
${formattedRelatedMeetingNotes}
Related resources:
Related people:
- "[[${tp.file.title}]]"
${formattedRelatedPeople}
aliases:
Creation date: "${date}"
Last modified: ${date}
---
`;
        break;
    default:
        tp.ui.alert('No applicable script for this note type.');
        return;
}

// Create the new file
await tp.file.create_new(content, newFile, true, baseFolder);
%>